/*
 * cheb.c
 *
 *  Created on: Dec 4, 2015
 *      Author: demo
 */

void chebpc(double c[], double d[], int n) {
	int k, j;
	double sv, *dd;
	dd = dvector(0, n - 1);
	for (j = 0; j < n; j++)
		d[j] = dd[j] = 0.0;
	for (j = n - 1; j >= 1; j--) {
		for (k = n - j; k >= 1; k--) {
			sv = d[k];
			d[k] = 2.0 * d[k - 1] - dd[k];
			dd[k] = sv;
		}
		sv = d[0];
		d[0] = -dd[0] + c[j];
		dd[0] = sv;

	}
	for (j = n - 1; j >= 1; j--)
		d[j] = d[j - 1] - dd[j];
	d[0] = -dd[0] + 0.5 * c[0];
	free_dvector(dd, 0, n - 1);
}

void pcshft(double a, double b, double d[], int n) {
	int k, j;
	double fac, cnst;
	cnst = 2.0 / (b - a);
	fac = cnst;
	for (j = 1; j < n; j++) {
		d[j] *= fac;
		fac *= cnst;
	}
	cnst = 0.5 * (a + b);
	for (j = 0; j <= n - 2; j++)
		for (k = n - 2; k >= j; k--)
			d[k] -= cnst * d[k + 1];
}
